var HISTORY = {};
HISTORY.max = 10;
HISTORY.savename = "ts_hs_history";
HISTORY.checkLocalStorage = function() {
	return typeof (Storage) === "function";
};
HISTORY.storeLocalStorage = function(name, data) {
	if (!HISTORY.checkLocalStorage())
		return false;
	return localStorage.setItem(name, JSON.stringify(data));
};
HISTORY.getLocalStorage = function(name) {
	if (typeof name === undefined)
		return null;
	if (!HISTORY.checkLocalStorage())
		return false;
	if (name in localStorage === false)
		return null;
	return JSON.parse(localStorage[name]);
};
HISTORY.getStored = function(){
	var history = HISTORY.getLocalStorage(HISTORY.savename);
	if ( ! history) return {};
	if (typeof(history) !== typeof({})) return {};
	else return history;
	
};
HISTORY.push = function(id, data){
	if ( ! HISTORY.checkLocalStorage()){
		return false;
	}
	if (isNaN(id)) return false;
	var stored = HISTORY.getStored();
	if (id in stored){
		delete stored[id];
	}
	if (Object.keys(stored).length >= HISTORY.max) {
		var reKeys = {};
		for(var i in stored){
			var item = stored[i];
			reKeys[item.time] = item;
		}
		var theKeys = Object.keys(reKeys);
		theKeys.sort();
		theKeys.reverse();
		var finalData = {};
		for(var r in theKeys){
			if (r < (HISTORY.max - 1) ){
				var obj = reKeys[theKeys[r]];
				finalData[obj.chapter_ID]  = obj;
			}else{
				break;
			}
		}
		stored = finalData;
	}
	data.time = new Date().getTime();
	stored[id] = data;
	HISTORY.storeLocalStorage(HISTORY.savename, stored);
	return true;
};
HISTORY.generateHTML = function(){
	var stored = HISTORY.getStored();
	if (Object.keys(stored).length === 0) return null;
	var reKeys = {};
	for(var i in stored){
		var item = stored[i];
		reKeys[item.time] = item;
	}
	var HTML = "";
	var theKeys = Object.keys(reKeys);
	theKeys.sort();
	for(var i in theKeys){
		var item = reKeys[theKeys[i]];
		var tpl = `<li class="ts-hs-item"><a href="${item.chapter_permalink}">${item.chapter_title}</a></li>`;
		HTML = tpl + HTML;
	}
	HTML = "<ul id='ts-hs-history'>" + HTML + "</ul>";
	return HTML;
}
HISTORY.run = function(){
	if (HISTORY.checkLocalStorage() === false){
		return jQuery("#ts-hs-widget").parent().parent().remove();
	}
	var theHTML = HISTORY.generateHTML();
	if (theHTML === null){
		return jQuery("#ts-hs-widget").parent().parent().remove();
	}
	jQuery("#ts-hs-widget").html(theHTML);
}
jQuery(document).ready(function(){
	HISTORY.run();
});